// params.h
// SQL Server Parameter class header
//
// Methods:
//		params()					Default constructor
//		~params()					Custom destructor releases data pointer
//		static int getparamcount()	Retrieves number of SQL Server parameters passed in
//		static void getparam()		Retrieves specified parameter from SQL Server
// Properties:
//		SRVRETCODE success			Set to FAIL if retrieving parameter failed, SUCCESS
//									if it was successful
//		ULONG length				The actual length of the data passed in the parameter
//		ULONG maxlength				The max length of the parameter passed in
//		BYTE *cdata					The BYTE pointer to the character data passed in
//		BOOL isnull					Set to TRUE if SQL NULL is passed in; FALSE if parameter
//									is not SQL NULL
//		BYTE type					The type of the parameter
//
// Michael Coles, MCDBA
// 7/2005
//
class params {
public:
	params() { };
	~params();

	static int getparamcount(SRV_PROC *srvproc);
	static void getparam(SRV_PROC *srvproc, int paramnum, params *p);

	SRVRETCODE	success;
	ULONG		length;
	ULONG		maxlength;
	BYTE		*cdata;
	BOOL		isnull;
	BOOL		isoutput;
	BYTE		type;
};
